from ..utils import full_name_wrapper, join_departments_data


def yandex_structure_gen():
    yield [
        'Название',
        'Название EN',
        'Код (url)',
        'Цепочка подразделений',
        'ФИО руководителя',
        'Логин руководителя',
        'Имена заместителей',
        'Логины заместителей',
        'Общая численость',
        'Численость',
    ]

    departments = join_departments_data()

    for dep in departments.values():
        yield [
            dep['name'],
            dep['name_en'],
            dep['url'],
            ' => '.join(d['name'] for d in dep['bread_crumb']),
            full_name_wrapper(dep['direct_chief']),
            dep['direct_chief']['login'] if dep['direct_chief'] else '',
            '; '.join(full_name_wrapper(p) for p in dep['deputies']),
            '; '.join(p['login'] for p in dep['deputies']),
            dep['persons_count'],
            dep['direct_persons_count'],
        ]
