from django.conf.urls import url, include

from staff.reports.views import departments as departments_views
from staff.reports.views import persons as persons_views

urlpatterns = [
    url(
        r'yandex-structure/?$',
        departments_views.yandex_structure,
        name='reports-yandex_structure',
    ),

    url(
        r'yandex-staff/?$',
        persons_views.yandex_staff,
        name='reports-yandex_staff',
    ),

    url(
        r'staff-ethic_courses_ru/?$',
        persons_views.staff_ethics_ru,
        name='reports-staff_ethic_courses_ru',
    ),
    url(
        r'staff-ethic_courses_en/?$',
        persons_views.staff_ethics_en,
        name='reports-staff_ethic_courses_en',
    ),

    url(r'', include('staff.oebs.reports.urls', namespace='reports-oebs')),
    url(r'', include('staff.dismissal.reports.urls', namespace='reports-dismissal')),
    url(r'', include('staff.lenta.reports.urls', namespace='reports-lenta')),
    url(r'', include('staff.person.reports.urls', namespace='reports-staff')),
]
