from django.contrib.auth.decorators import permission_required

from staff.lib.decorators import responding_xlsx

from ..objects.departments import yandex_structure_gen


@permission_required(
    'django_intranet_stuff.can_view_structure_report', raise_exception=True)
@responding_xlsx(prefix='yandex_structure')
def yandex_structure(request):
    """
    Все подразделения (все неудалённые подразделения, которые есть в Стаффе)
        * название подразделения на русском,
        * название подразделения на английском,
        * код подразделения,
        * цепочка родителей подразделения на русском,
        * имя и фамилия руководителя на русском (если есть),
        * логин руководителя (если есть),
        * имена заместителей (список),
        * логины заместителей
                (список в том же порядке, как в предыдущем пункте),
        ! руководитель в России/Украине/... (по колонке на каждую страну),
        * численность подразделения общая (включая вложенные),
        * численность самого подразделения,
    """

    return [['yandex_structure', yandex_structure_gen()]]
