from django.contrib.auth.decorators import permission_required

from staff.lib.decorators import responding_csv, responding_xlsx

from ..objects.persons import EthicReport, yandex_staff_gen


@permission_required(
    'django_intranet_stuff.can_view_staff_report', raise_exception=True)
@responding_xlsx(prefix='yandex_staff')
def yandex_staff(request):
    """
    Руководители сотрудников
    (все неуволенные сотрудники, которые есть в Стаффе)
        * имя и фамилия сотрудника на русском,
        * логин сотрудника,
        * название подразделения сотрудника на русском,
        * цепочка родителей подразделения на русском,
        * имя и фамилия непосредственного руководителя на русском,
        * логин непосредственного руководителя
    """

    return [['yandex_staff', yandex_staff_gen()]]


@permission_required('django_intranet_stuff.can_view_staff_ethic_report',
                     raise_exception=True)
@responding_csv(filename='ethic_courses_ru')
def staff_ethics_ru(request):
    """
    Отчёт для курсов по этике для пользователей с русским интерфейсом
    """
    return EthicReport('ru').lines()


@permission_required('django_intranet_stuff.can_view_staff_ethic_report',
                     raise_exception=True)
@responding_csv(filename='ethic_courses_en')
def staff_ethics_en(request):
    """
    Отчёт для курсов по этике для пользователей с английским интерфейсом
    """
    return EthicReport('en').lines()
