from django.contrib import admin
from django import forms

from staff.lib.utils.admin import StaffModelAdmin

from .models import ContractorFirm, Rfid, Badge


class ContractorFirmAdmin(admin.ModelAdmin):
    list_display = ["name", 'name_en', 'desc']


class RFIDAdmin(admin.ModelAdmin):
    list_display = 'code', 'created_at', 'updated_at'


class BadgeForm(forms.ModelForm):
    rfid = forms.ModelChoiceField(Rfid.objects.all(), required=False)

    class Meta:
        fields = '__all__'
        model = Badge


class BadgeAdmin(StaffModelAdmin):
    staff_field = 'person'
    list_display = (
        'rfid',
        'owner',
        'reason',
        'state',
        'person',
        'contractor',
        'first_name',
        'last_name',
        'first_name_en',
        'last_name_en',
        'login',
        'preprofile',
        'join_at',
    )

    fields = (
        'rfid',
        'owner',
        'state',
        'reason',
        'person',
        ('first_name', 'last_name'),
        ('first_name_en', 'last_name_en'),
        'contractor',
        'anonym_food_allowed',
        'preprofile',
        'login',
        'photo',
        'position',
        'join_at',
        'office_id',
        ('updated_at', 'changed_by'),
    )
    search_fields = (
        'rfid__code',
        'login',
        # 'preprofile_id',  TODO: do possible to search by integer field
        'first_name',
        'last_name',
        'first_name_en',
        'last_name_en',
    )
    readonly_fields = ('updated_at', 'changed_by')
    list_filter = 'owner', 'reason'
    form = BadgeForm
    # actions = ['hire_all', 'fire_all']

    def rfid(self, obj):
        return obj.rfid

    # ### Global actions
    # def fire_all(self, *args, **kwargs):
    #     from staff.rfid.candidates import fire_all
    #     fire_all()
    # fire_all.short_description = "Deactivate all discharged employees"
    # fire_all.acts_on_all = True

    # def hire_all(self, *args, **kwargs):
    #     from staff.rfid.candidates import hire_all
    #     hire_all()
    # hire_all.short_description = "Hire all new employees (from candidates)"
    # hire_all.acts_on_all = True


admin.site.register(ContractorFirm, ContractorFirmAdmin)
admin.site.register(Rfid, RFIDAdmin)
admin.site.register(Badge, BadgeAdmin)
