from staff.lib.utils.ordered_choices import OrderedChoices

CODE_STATUS = OrderedChoices(
    ('IN_RESERVE', 'in_reserve'),
    ('NEW', 'new'),
    ('USED', 'used'),
    ('DELETED', 'deleted'),
)

OWNER = OrderedChoices(
    ('EMPLOYEE', 'employee', 'rfid.owner.employee'),
    ('CANDIDATE', 'candidate', 'rfid.owner.candidate'),
    ('ANONYM', 'anonym', 'rfid.owner.anonymous'),
)

STATE = OrderedChoices(
    ('NOCODE', 'nocode', 'rfid.state.no_code'),
    ('ACTIVE', 'active', 'rfid.state.active'),
    ('LOST', 'lost', 'rfid.state.lost'),
    ('INACTIVE', 'inactive', 'rfid.state.inactive'),
    ('DISCHARGED', 'discharged', 'rfid.state.discharged'),
    ('BLOCKED', 'blocked', 'rfid.state.blocked'),
)

REASON = OrderedChoices(
    # Reason for deactivating a key
    ('LOST', 'lost', 'rfid.reason.lost'),
    ('DISCHARGED', 'discharged', 'rfid.reason.discharged'),
    ('INACTIVE', 'inactive', 'rfid.reason.inactive'),
)
