from staff.rfid.models import ContractorFirm
from .base import ListController, BaseController, ReadOnlyField


class Contractor(BaseController):
    id = ReadOnlyField('id')
    name = ReadOnlyField('name', i18n=True)
    desc = ReadOnlyField('desc')
    is_active = ReadOnlyField('is_active')


class Contractors(ListController):
    model = ContractorFirm
    controllers = Contractor,

    def values_active(self, *fields):
        return self.filter(is_active=True).values(*fields)

    def values(self, *fields):
        self._requested_fields = list(fields)
        q_fields = list(fields)

        if 'name' in q_fields:
            q_fields.append('name_en')

        super(Contractors, self).values(*q_fields)
        return self
