class RfidException(Exception):
    pass


class FieldIsRequired(RfidException):
    def __init__(self, message='', field=''):
        self.message = 'Field "{0}" is required'.format(field)
        self.field = field


class RfidFieldError(RfidException):
    """Base rfid field error"""


class RfidModifyReadOnlyFieldError(RfidFieldError):
    """Attempt to modify read only field error."""
    def __init__(self, message='', field=''):
        self.message = 'Field "{0}" is read only'.format(field)
        self.field = field


class RfidCandidateBadgeAlreadyExist(RfidException):
    """Badge for candidate already created"""


class RfidPersonError(RfidFieldError):
    """Base person field error"""


class RfidPersonRewriteError(RfidPersonError):
    """You cannot change the person"""


class RfidPersonHasBadgeError(RfidPersonError):
    """Person has badge"""


class RfidCodeError(RfidFieldError):
    """Base rfid code error"""


class RfidCodeRewriteError(RfidCodeError):
    """You cannot change the code"""


class RfidCodeEmptyError(RfidCodeError):
    """Code cannot be empty"""


class RfidCodeBusyError(RfidCodeError):
    """Code is busy"""


class RfidCodeCannotBeUsedError(RfidCodeError):
    """Code should be used for employees from Russian Yandex offices only"""


class RfidCodeDeleteError(RfidCodeError):
    """Code is busy and can not be deleted"""


class RfidBadgeDeleteError(RfidCodeError):
    """Badge can not be deleted due to it's state"""


class RfidUnavailableStateTransition(RfidException):
    """Unable to deactivate, block or reactivate badge because of it`s state"""


class DoesNotExist(RfidException):
    pass


class MultipleObjectsReturned(RfidException):
    pass
