import yenv
from django.dispatch import receiver
from django.db import models

from staff.person.models import Staff

from staff.dismissal.signals import dismissal_completed

from .tasks import HirePeople, FirePeople


@receiver(models.signals.post_save, sender=Staff)
def rfid_hire_people(sender, created, instance, **kwargs):
    """Hire people when staff is updated"""
    hire_method = HirePeople if yenv.type == 'development' else HirePeople.delay
    if created:
        hire_method(person_ids=[instance.id])


@receiver(dismissal_completed)
def rfid_fire_people(staff, **kw):
    """Fire people when staff is dismissed"""
    fire_method = FirePeople if yenv.type == 'development' else FirePeople.delay
    fire_method(person_ids=[staff.id])
