# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('preprofile', '0001_initial'),
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Badge',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(null=True, auto_now_add=True)),
                ('updated_at', models.DateTimeField(null=True, auto_now=True)),
                ('owner', models.CharField(max_length=20, choices=[('employee', 'rfid.owner.employee'), ('candidate', 'rfid.owner.candidate'), ('anonym', 'rfid.owner.anonymous')])),
                ('state', models.CharField(max_length=20, choices=[('nocode', 'rfid.state.no_code'), ('active', 'rfid.state.active'), ('lost', 'rfid.state.lost'), ('inactive', 'rfid.state.inactive'), ('discharged', 'rfid.state.discharged'), ('blocked', 'rfid.state.blocked')])),
                ('reason', models.CharField(max_length=20, blank=True, null=True, choices=[('lost', 'rfid.reason.lost'), ('discharged', 'rfid.reason.discharged'), ('inactive', 'rfid.reason.inactive')])),
                ('anonym_food_allowed', models.BooleanField(default=False)),
                ('first_name', models.CharField(max_length=256, blank=True, null=True)),
                ('first_name_en', models.CharField(max_length=256, blank=True, null=True)),
                ('last_name', models.CharField(max_length=256, blank=True, null=True)),
                ('last_name_en', models.CharField(max_length=256, blank=True, null=True)),
                ('login', models.CharField(max_length=4096, blank=True, null=True)),
                ('photo', models.CharField(max_length=4096, blank=True, null=True)),
                ('position', models.TextField(blank=True, null=True)),
                ('join_at', models.DateField(blank=True, null=True)),
                ('office_id', models.IntegerField(blank=True, null=True)),
                ('changed_by', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
            options={
                'permissions': (('list_reserve', 'API:Can see reserve keys'), ('edit_reserve', 'API:Can edit reserve keys'), ('list_candidates', 'API:Can see candidates'), ('edit_candidates', 'API:Can edit candidates'), ('list_anonymous', 'API:Can see anonymous'), ('edit_anonymous', 'API:Can edit anonymous'), ('list_employees', 'API:Can see employees'), ('edit_employees', 'API:Can edit employees'), ('use_list_handle', 'Robot-API:Can use list handle'), ('use_key_handle', 'Robot-API:Can use key handle'), ('can_export_payers', 'API: Can export payers'), ('change_anonym_food', 'Can change anonym food permission'), ('robot_with_rfid_api_access', 'Permission for robots group, allows access to rfid api')),
            },
        ),
        migrations.CreateModel(
            name='BadgeChange',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(null=True, auto_now_add=True)),
                ('updated_at', models.DateTimeField(null=True, auto_now=True)),
                ('badge_id', models.IntegerField()),
                ('code', models.CharField(max_length=128)),
                ('state', models.CharField(max_length=32, choices=[('nocode', 'rfid.state.no_code'), ('active', 'rfid.state.active'), ('lost', 'rfid.state.lost'), ('inactive', 'rfid.state.inactive'), ('discharged', 'rfid.state.discharged'), ('blocked', 'rfid.state.blocked')])),
                ('is_sent', models.BooleanField(default=False)),
                ('is_sent_to_hd', models.BooleanField(default=False)),
                ('last_update', models.DateTimeField(null=True)),
                ('person', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractorFirm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(null=True, auto_now_add=True)),
                ('updated_at', models.DateTimeField(null=True, auto_now=True)),
                ('name', models.CharField(max_length=256)),
                ('name_en', models.CharField(max_length=256)),
                ('desc', models.TextField(blank=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Rfid',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(null=True, auto_now_add=True)),
                ('updated_at', models.DateTimeField(null=True, auto_now=True)),
                ('code', models.CharField(max_length=128, unique=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='badge',
            name='contractor',
            field=models.ForeignKey(blank=True, null=True, to='rfid.ContractorFirm'),
        ),
        migrations.AddField(
            model_name='badge',
            name='person',
            field=models.ForeignKey(blank=True, null=True, related_name='badges', to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='badge',
            name='preprofile',
            field=models.ForeignKey(unique=True, blank=True, null=True, to='preprofile.Preprofile'),
        ),
        migrations.AddField(
            model_name='badge',
            name='rfid',
            field=models.OneToOneField(blank=True, null=True, to='rfid.Rfid'),
        ),
    ]
