from django.db import models

from staff.rfid.models.base import BaseRfidModel


class ContractorFirm(BaseRfidModel):
    name = models.CharField(max_length=256)
    name_en = models.CharField(max_length=256)
    desc = models.TextField(blank=True)
    is_active = models.BooleanField(default=True)

    def __str__(self):
        return self.name_en or self.name
