from django import forms
from django.conf import settings

from staff.lib.forms.fields import DepartmentField

from staff.security.models import DataProfile

jquery_url = '//js.static.yandex.net/jquery/1.3.2/_jquery.js'
departments_autocomplete = '//%s/media/js/_js-autocomplete_departments.js' % settings.CENTER_MASTER


# django admin forms
class DataProfileAdminForm(forms.ModelForm):
    department = DepartmentField(label='Подразделение', required=False)

    class Meta:
        fields = '__all__'
        model = DataProfile

    class Media:
        js = (jquery_url, departments_autocomplete)
