# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessControlList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(max_length=256, default='Not specified!')),
                ('description', models.CharField(max_length=1024, default='Not specified!')),
            ],
        ),
        migrations.CreateModel(
            name='DataProfile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('own_department_only', models.BooleanField(default=False)),
                ('chiefed_departments_only', models.BooleanField(default=False)),
                ('own_office_only', models.BooleanField(default=False)),
                ('department', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Department')),
                ('office', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Office')),
            ],
        ),
        migrations.AddField(
            model_name='accesscontrollist',
            name='dataprofiles',
            field=models.ManyToManyField(blank=True, related_name='acl', to='security.DataProfile'),
        ),
        migrations.AddField(
            model_name='accesscontrollist',
            name='group',
            field=models.OneToOneField(related_name='acl', to='django_intranet_stuff.Group'),
        ),
    ]
