from staff.security.models import AccessControlList, DataProfile


class AccessControlListService(object):
    """
    Класс для работы со списками контроля доступа пользователя
    """
    def __init__(self, staff):
        self.staff = staff

    def get_all_lists(self):
        """
        Возвращает QuerySet со всеми списками контроля доступа пользователя..
        """
        user_groups = self.staff.in_groups.active().values_list('pk', flat=True)
        return AccessControlList.objects.filter(group__in=list(user_groups))

    def get_all_dataprofiles(self):
        """
        Возвращает QuerySet со всеми датапрофилями пользователя.
        """
        acl_set = self.get_all_lists().values_list('pk', flat=True)
        return DataProfile.objects.filter(acl__in=set(acl_set))
