import logging

from staff.celery_app import app
from staff.lib.tasks import LockedTask

from staff.person.dismissed import (
    revoke_dismissed_users_rights,
    clear_dismissed_tables,
)

logger = logging.getLogger('staff.security.tasks')


@app.task(ignore_result=True)
class RevokeDismissedRights(LockedTask):
    """
    Revoke personal permissions given to django User instances of dismissed users
    """
    def locked_run(self):
        revoke_dismissed_users_rights()


@app.task(ignore_result=True)
class ClearDismissedTables(LockedTask):
    """
    Clear tables of dismissed persons
    """
    def locked_run(self):
        clear_dismissed_tables()
