from itertools import chain

from django.shortcuts import render_to_response
from django.http import Http404
from django.template import RequestContext

from staff.lib.decorators import require_permission

from .forms import SpamSendForm
from .controller import SpamMessages, SendException


@require_permission('django_intranet_stuff.can_send_spam', exception=Http404)
def sendspam(request):
    form = SpamSendForm(data=request.POST.copy() or None)

    is_post = request.method == 'POST'
    done = 'HAS PROBLEM.' if is_post else ''

    if is_post and form.is_valid():
        messages = SpamMessages(**form.cleaned_data)
        try:
            messages.send()
            done = 'DONE!'
            form.data['logins'] = ''
        except SendException as e:
            msg = (
                'При обработке "{fail_person}" возникла ошибка "{exception}".'
                ' Необработанные логины остались в списке.'
            ).format(fail_person=e.fail_person.login, exception=e)
            form._errors["logins"] = form.error_class([msg])
            form.data['logins'] = ', '.join(chain(
                [e.fail_person.login], (p.login for p in e.not_performed)
            ))
            done = 'FAIL!'

    return render_to_response(
        'sendspam.html', RequestContext(request, {'form': form, 'done': done})
    )
