import granular_settings
granular_settings.set(globals())

import os
import json

import yenv

PREFIX = 'STAFF__'

for env_name, env_value in os.environ.items():
    if env_name.startswith(PREFIX):
        try:
            env_value = json.loads(env_value)
        except ValueError:
            pass

        globals()[env_name[len(PREFIX):]] = env_value


# Load taxi credentials
if yenv.type != 'development':
    try:
        with open(TAXI_CREDENTIALS_PATH, 'r') as credentials_file:
            TAXI_API_CREDENTIALS = json.loads(credentials_file.read())
    except Exception as exc:
        import logging
        logger = logging.getLogger(__name__)
        logger.exception('Error while getting taxi credentials from file: %s', str(exc))
        TAXI_API = {}
