from staff.dismissal.objects import DismissalCtl
from staff.dismissal.services import DismissalService
from staff.lib.models.roles_chain import chiefs_chain_for_person
from staff.person.models import Staff


def dismiss(*staff_args, **staff_kwargs):
    failed = []
    for person in Staff.objects.filter(*staff_args, **staff_kwargs).prefetch_related('department'):
        if DismissalService.exists_dismissal_procedure_for(person):
            failed.append(person.login)
            continue
        chief_login = chiefs_chain_for_person(person=person, fields=['login'])[0]['login']
        DismissalCtl(author=Staff.objects.get(login=chief_login), person=person).complete_fast()
    print('Can\'t dismiss fast persons {}'.format(failed))
