from staff.lib.utils.library import Library


class DictionariesLibrary(Library):
    @property
    def dynamic_dictionaries(self):
        return {k: v for k, v in self._library.items() if v.is_dynamic}


reports_library = Library(lambda report_cls: report_cls.report_name)
dictionaries_library = DictionariesLibrary(lambda dictionary_cls: dictionary_cls.name)
register_report = reports_library.register
register_dictionary = dictionaries_library.register

from staff.stats.reports import *  # noqa
from staff.stats.dictionaries import *  # noqa
