from collections import namedtuple

from django.utils import timezone

DepartmentUnit = namedtuple('DepartmentUnit', ['id'])


def get_beginning_of_day(dt):
    return dt.replace(hour=0, minute=0, second=0, microsecond=0)


def str_to_date(date_str):
    dt = timezone.datetime.strptime(date_str, '%Y-%m-%d')
    return dt
