from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin
from staff.survey import models


class SurveyAdmin(StaffModelAdmin):
    model = models.Survey

    list_display = (
        'block_text',
        'block_text_en',
        'button_text',
        'button_text_en',
        'button_link',
        'button_link_en',
        'department',
        'office',
        'start_at',
        'end_at',
        'created_at',
    )


admin.site.register(models.Survey, SurveyAdmin)
