from django.db import models

from staff.departments.models import Department
from staff.map.models import Office


class Survey(models.Model):
    block_text = models.CharField(max_length=100)
    block_text_en = models.CharField(max_length=100, null=True, blank=True)

    button_text = models.CharField(max_length=100)
    button_text_en = models.CharField(max_length=100, null=True, blank=True)

    button_link = models.CharField(max_length=255)
    button_link_en = models.CharField(max_length=255, null=True, blank=True)

    department = models.ForeignKey(Department, on_delete=models.CASCADE, null=True, blank=True)
    office = models.ForeignKey(Office, on_delete=models.CASCADE, null=True, blank=True)

    start_at = models.DateTimeField()
    end_at = models.DateTimeField()
    created_at = models.DateTimeField(auto_now_add=True)
