from django.contrib.auth.decorators import permission_required
from django.http import JsonResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.views.decorators.http import require_http_methods

from staff.lib.forms.errors import sform_general_error

from staff.syncs.manual.belarus_leave_balance.controllers import parse_file, upload_leave_balance
from staff.syncs.manual.belarus_leave_balance.forms import FileImportForm


@require_http_methods(['GET', 'POST'])
@permission_required('syncs.can_update_belarus_leave_balance')
def update_belarus_leave_balance(request):
    html_template = 'belarus_leave_balance/index.html'

    if request.method == 'GET':
        return render_to_response(
            html_template,
            {'form': FileImportForm(), 'result': None},
            context_instance=RequestContext(request)
        )

    form = FileImportForm(request.POST, request.FILES)
    if not form.is_valid():
        return JsonResponse(sform_general_error('missing_file'), status=400)

    try:
        data = parse_file(request.FILES['import_file'])
        upload_result = upload_leave_balance(data)
        if 'TEMP' in request.META['QUERY_STRING']:
            return render_to_response(
                html_template,
                {'form': form, 'result': upload_result},
                context_instance=RequestContext(request)
            )
        return JsonResponse(upload_result, status=200)
    except ValueError:
        return JsonResponse(sform_general_error('incorrect_template'), status=400)
