from django.db import models

from staff.umbrellas.models import Umbrella


class Permissions(models.Model):
    class Meta:
        managed = False
        permissions = (
            ('can_update_belarus_leave_balance', 'Permission for updating vacation balance for belarus'),
        )


class StartrekVs(models.Model):
    issue_key = models.CharField(max_length=24, unique=True)
    abc_service_id = models.IntegerField(null=True)
    name = models.CharField(max_length=128)
    deadline = models.DateField(null=False)

    class Meta:
        db_table = 'umbrellas_startrekvs'


class StartrekUmbrella(models.Model):
    issue_key = models.CharField(max_length=24, unique=True)
    name = models.CharField(max_length=128)
    vs = models.ForeignKey(StartrekVs, null=False, related_name='umbrellas')
    staff_instance = models.ForeignKey(Umbrella, null=True)

    class Meta:
        db_table = 'umbrellas_startrekumbrella'
