import logging

from django.db.models import QuerySet

from staff.lib.db import atomic
from staff.umbrellas.models import Umbrella

from staff.syncs.models import StartrekUmbrella


logger = logging.getLogger(__name__)


class UmbrellaLinker:
    source_query_set: QuerySet = StartrekUmbrella.objects.all()
    source_key: str = 'issue_key'
    source_link_field_name: str = 'staff_instance'
    target_query_set: QuerySet = Umbrella.objects.all()
    target_key: str = 'issue_key'

    @atomic()
    def run(self) -> None:
        unlinked = list(
            self.source_query_set
            .filter(**{self.source_link_field_name + '__isnull': True})
            .select_for_update()
        )
        missing = {getattr(x, self.source_key): x for x in unlinked}
        targets = dict(
            self.target_query_set
            .filter(**{self.target_key + '__in': missing.keys()})
            .values_list(self.target_key, 'id')
        )

        linked = 0

        for key, instance in missing.items():
            link = targets.get(key)

            if link is not None:
                linked += 1
                setattr(instance, self.source_link_field_name + '_id', link)
                instance.save()

        logger.info('Linked %s of %s', linked, len(missing))
