from staff.celery_app import app
from staff.lib.tasks import LockedTask

from staff.syncs.umbrellas.link import UmbrellaLinker
from staff.syncs.umbrellas.roll_up import UmbrellaRollUpper
from staff.syncs.umbrellas.sync import UmbrellasSync
from staff.syncs.umbrellas.umbrellas_fetcher import UmbrellasFetcher


@app.task(ignore_result=True)
class SyncUmbrellas(LockedTask):
    def locked_run(self):
        UmbrellasSync(UmbrellasFetcher()).sync()
        UmbrellaLinker().run()
        UmbrellaRollUpper.rollup(create_absent=True)
