<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0">
    <xsl:output method="xml" indent="no"/>

    <xsl:template match="/">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simple" page-height="5cm"
                                       page-width="9cm" margin-left="0cm" margin-right="0cm">
                    <fo:region-body/>
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simple">
                <fo:flow flow-name="xsl-region-body">
                    <xsl:apply-templates select="//card"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="row">
        <xsl:param name="y"/>
        <xsl:param name="text"/>
        <xsl:param name="fill" select="''"/>
        <xsl:variable name="x">
            <xsl:choose>
                <xsl:when test="starts-with(normalize-space($text), '1')">77.25</xsl:when>
                <xsl:otherwise>77.9373</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <text xmlns="http://www.w3.org/2000/svg" transform="matrix(1 0 0 1 {$x} {71.574 + $y * 7.35055})" font-family="'TextBookNewRegular'" font-size="6">
            <xsl:if test="$fill != ''">
                <xsl:attribute name="fill">
                    <xsl:value-of select="$fill"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="normalize-space($text)"/>
        </text>
    </xsl:template>
    <xsl:template name="namepart">
        <xsl:param name="text"/>
        <xsl:variable name="maxl">
            <xsl:choose>
                <xsl:when test="string-length(name1) > string-length(name2)">
                    <xsl:value-of select="string-length(name1)"/>
                </xsl:when> <xsl:otherwise>
                    <xsl:value-of select="string-length(name2)"/>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:variable>
        <xsl:variable name="fontsize">
            <xsl:choose>
                <xsl:when test="normalize-space(name2) = ''">
                    <xsl:choose>
                        <xsl:when test="$maxl &gt;  22">11</xsl:when>
                        <xsl:when test="$maxl &gt;  15">12</xsl:when>
                        <xsl:otherwise>13</xsl:otherwise>
                    </xsl:choose>
                </xsl:when><xsl:otherwise>
                11
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <text xmlns="http://www.w3.org/2000/svg"
                font-family="'TextBookNewRegular'" font-size="{$fontsize}">
                <xsl:value-of select="normalize-space($text)"/></text>

    </xsl:template>
    <xsl:template name="pospart">
        <xsl:param name="text"/>
        <xsl:param name="fsize"/>
        <xsl:param name="yshift"/>

         <xsl:variable name="ypos">
             <xsl:choose><xsl:when test="normalize-space(name2) = ''"
                                >35.52</xsl:when>
                        <xsl:otherwise
                                >49.5242</xsl:otherwise>
                        </xsl:choose>
         </xsl:variable>

        <text xmlns="http://www.w3.org/2000/svg"
                font-family="'TextBookNewRegular'" font-size="{$fsize}"
                transform="translate(77.9373 {$ypos + $yshift} )"
            >
            <xsl:value-of select="normalize-space($text)"/>
        </text>
    </xsl:template>

    <xsl:template match="card">
        <xsl:variable name="fSize2">
            <xsl:choose>
                <xsl:when test="string-length(normalize-space(position1)) &gt; 40">6</xsl:when>
                <xsl:otherwise>7</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="tel">
            <xsl:choose>
                <xsl:when test="en">tel.: </xsl:when>
                <xsl:otherwise>тел.: </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="fax">
            <xsl:choose>
                <xsl:when test="en">fax: </xsl:when>
                <xsl:otherwise>факс: </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="cell">
            <xsl:choose>
                <xsl:when test="en">cell: </xsl:when>
                <xsl:otherwise>моб.: </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ext">
            <xsl:choose>
                <xsl:when test="en">ext.: </xsl:when>
                <xsl:otherwise>доб.: </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <!-- <xsl:variable name="yandex">
            <xsl:choose>
                <xsl:when test="en">www.yandex.com</xsl:when>
                <xsl:otherwise>www.yandex.ru</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> -->
        <fo:block font-size="0">
            <fo:instream-foreign-object width="9cm" height="5cm"
                                        content-width="9cm" content-height="5cm"
                                        display-align="center" text-align="center">
                <svg version="1.2" baseProfile="tiny"
                     xmlns="http://www.w3.org/2000/svg"
                     id="Layer_1" xmlns:xlink="http://www.w3.org/1999/xlink"
                     x="0px" y="0px" width="9cm" height="5cm"
                     viewBox="0 0 255.118 141.732" xml:space="preserve"
                     fill='rgb-icc(#CMYK, 0,0,0,1)'>
                    <!--
                        <text transform="translate(77.3748 24.2869)" font-family="'TextBookNewRegular'" font-size="13"><xsl:choose><xsl:when test="string-length(normalize-space(name)) &gt; 22"><xsl:attribute name="font-size">11</xsl:attribute></xsl:when><xsl:when test="string-length(normalize-space(name)) &gt; 20"><xsl:attribute name="font-size">12</xsl:attribute></xsl:when></xsl:choose><xsl:value-of select="normalize-space(name)"/></text>
                    -->
                    <g transform="translate(77.3748 24.2869)">
                    <xsl:call-template name="namepart">
                        <xsl:with-param name="text" select="name1"/>
                    </xsl:call-template>
                    </g>

                    <g transform="translate(77.3748 37.0)">
                    <xsl:call-template name="namepart">
                        <xsl:with-param name="text" select="name2"/>
                    </xsl:call-template>
                    </g>


                    <xsl:call-template name="pospart">
                        <xsl:with-param name="text" select="position1"/>
                        <xsl:with-param name="fsize" select="$fSize2"/>
                        <xsl:with-param name="yshift" select="0"/>
                    </xsl:call-template>

                    <xsl:if test="normalize-space(position2) != ''">
                        <xsl:call-template name="pospart">
                            <xsl:with-param name="text" select="position2"/>
                            <xsl:with-param name="fsize" select="$fSize2"/>
                            <xsl:with-param name="yshift" select="8"/>
                         </xsl:call-template>
                    </xsl:if>
                    <xsl:call-template name="row">
                        <xsl:with-param name="y" select="0"/>
                        <xsl:with-param name="text" select="address1"/>
                    </xsl:call-template>
                    <xsl:call-template name="row">
                        <xsl:with-param name="y" select="1"/>
                        <xsl:with-param name="text" select="address2"/>
                    </xsl:call-template>
                    <xsl:call-template name="row">
                        <xsl:with-param name="y" select="2"/>
                        <xsl:with-param name="text">
                            <!-- <xsl:choose>
                                <xsl:when test="normalize-space(ext) != ''">
                                    <xsl:value-of select="concat($tel, normalize-space(phone), ', ', $ext, ext)"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="concat($tel, normalize-space(phone))"/>
                                </xsl:otherwise>
                            </xsl:choose> -->
                            <xsl:value-of select="normalize-space(phone)"/>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:if test="normalize-space(fax) != ''">
                        <xsl:call-template name="row">
                            <xsl:with-param name="y" select="3"/>
                            <xsl:with-param name="text" select="fax"/>
                        </xsl:call-template>
                    </xsl:if>
                    <!--xsl:if test="contains(address2, 'Burlingame')"-->
                        <xsl:call-template name="row">
                            <xsl:with-param name="y" select="4"/>
                            <xsl:with-param name="text" select="site"/>
                        </xsl:call-template>
                    <!--/xsl:if-->
                    <xsl:variable name="sposition">5.7
                    <!--xsl:choose><xsl:when test="contains(address2, 'Burlingame')">5.7</xsl:when><xsl:otherwise>4.7</xsl:otherwise></xsl:choose-->
                    </xsl:variable>
                    <xsl:call-template name="row">
                        <xsl:with-param name="y" select="$sposition"/>
                        <xsl:with-param name="text" select="email"/>
                        <xsl:with-param name="fill" select="'rgb-icc(#CMYK,1, 0.4, 0.0, 0.0)'"/>
                    </xsl:call-template>
                    <xsl:if test="normalize-space(mobile) != ''">
                        <xsl:call-template name="row">
                            <xsl:with-param name="y" select="$sposition + 1"/>
                            <xsl:with-param name="text" select="mobile"/>
                            <xsl:with-param name="fill" select="'rgb-icc(#CMYK,1, 0.4, 0.0, 0.0)'"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="normalize-space(contact) != ''">
                        <xsl:call-template name="row">
                            <xsl:with-param name="y">
                                <xsl:choose><xsl:when test="normalize-space(mobile) != ''"><xsl:value-of select="$sposition + 1.9"/></xsl:when><xsl:otherwise><xsl:value-of select="$sposition + 1"/></xsl:otherwise></xsl:choose>
                            </xsl:with-param>
                            <xsl:with-param name="text" select="contact"/>
                            <xsl:with-param name="fill" select="'rgb-icc(#CMYK,1, 0.4, 0.0, 0.0)'"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:choose><xsl:when test="en">
                        <g transform="matrix(0.168349784,0,0,0.168349784,-10,-1)">

                            <!-- 'ndex' -->
                            <path d="M279.406,405.953c-7.278,0-14.865,5.309-14.865,5.309v-3.414c0-0.749-0.303-1.046-1.051-1.046h-9.288
                                c-0.747,0-1.197,0.45-1.197,1.046v72.807c0,0.75,0.299,1.203,1.049,1.203h9.437c0.6,0,1.051-0.453,1.051-1.203v-62.317
                                c0,0,4.383-2.777,9.698-2.777c5.065,0,9.065,2.515,9.065,7.671c0,3.594,0,57.424,0,57.424c0,0.75,0.451,1.203,1.201,1.203h9.284
                                c0.75,0,1.049-0.601,1.049-1.203v-60.691C294.839,410.824,289.225,405.953,279.406,405.953z M353.405,369.427h-9.288
                                c-0.754,0-1.201,0.453-1.201,1.051v36.733c-3.57-1.369-6.812-2.094-9.436-2.094c-15.09,0-25.445,14.42-25.445,42.154
                                c0,23.757,10.074,36.498,23.222,36.498c5.542,0,10.118-3.176,13.466-6.153l2.033,3.437c0.342,0.594,0.623,0.799,1.309,0.799
                                l5.341,0.006c0.596,0,1.045-0.453,1.045-1.203V370.478C354.45,369.728,354.153,369.427,353.405,369.427z M342.916,471.581
                                c-2.288,1.245-5.17,2.396-8.276,2.396c-9.931,0-14.319-11.781-14.319-29.156c0-15.286,4.473-30.413,13.606-30.413
                                c3.089,0,6.063,1.02,8.989,3.342V471.581z M388.987,405.268c-15.473,0-23.104,20.238-23.104,42.255
                                c0,23.055,10.885,35.974,24.888,35.974c6.153,0,12.282-2.424,16.3-4.655c0.61-0.346,0.722-0.825,0.575-1.416l-1.169-4.877
                                c-0.15-0.592-0.447-0.891-1.191-0.891c-0.33,0-5.406,1.487-10.343,1.487c-11.455,0-16.711-10.188-16.711-23.715
                                c0-1.784,0-3.286,0-3.286s5.693,0.788,9.118,0.788h21.612v-6.252C408.962,417.622,400.889,405.268,388.987,405.268z
                                M388.237,437.561c-3.415,0-9.644,0.847-9.644,0.847s0.082-2.485,0.379-4.867c1.342-12.651,4.357-19.044,9.563-19.044
                                c4.531,0,7.628,6.543,8.374,18c0.148,2.384,0.148,5.064,0.148,5.064H388.237z M218.759,405.001c-4.505,0-11.53,1.721-16.226,3.828
                                c-0.92,0.414-1.5,0.777-1.5,1.499c0,0.429,0.215,0.922,0.453,1.351l3.162,6.771c0.326,0.764,0.846,0.939,1.278,0.939
                                c0.466,0,0.848-0.223,1.269-0.49c4.571-2.93,7.927-4.535,10.585-4.535c3.512,0,5.894,2.329,7.368,5.83
                                c1.367,3.267,1.898,7.774,1.898,12.986c0,0.668,0.004,1.533,0.004,1.533c-2.887-1.807-7.882-2.801-10.376-2.801
                                c-13.423,0-20.66,12.749-20.66,26.393c0,14.688,8.459,25.464,18.623,25.464c5.661,0,10.787-3.325,14.222-7.509
                                c0,0,1.828,4.354,2.068,4.875c0.242,0.522,0.486,0.716,1.175,0.716l5.433,0.006c0.603,0,1.05-0.453,1.05-1.203v-42.229
                                c0-10.387-0.523-18.302-3.267-23.698C231.882,407.959,225.767,405.001,218.759,405.001z M227.051,470.058
                                c-2.662,2.572-5.854,3.919-8.72,3.919c-2.867,0-5.081-1.327-6.861-3.78c-2.159-2.984-3.169-7.581-3.169-12.674
                                c0-8.058,2.971-16.323,9.278-16.323c3.118,0,6.544,1.019,9.472,3.348V470.058z M457.451,406.792h-8.278
                                c-0.925,0-1.396,0.483-1.637,1.112c-0.525,1.374-4.019,10.593-5.456,14.407c-0.892,2.381-3.108,8.637-3.656,10.187
                                c-0.454-1.267-2.062-5.741-2.998-8.162c-0.885-2.296-5.494-14.448-6.079-15.942c-0.308-0.802-0.658-1.602-1.846-1.602h-9.065
                                c-0.994,0-1.559,1.091-1.235,1.768c0.319,0.678,14.768,33.577,14.768,33.577S416.451,478.968,416,479.798
                                c-0.451,0.827,0.117,2.054,1.222,2.054h7.946c1.354,0,1.881-0.712,2.29-1.85c1.141-3.198,2.841-7.647,5.251-14.52
                                c1.368-3.931,3.427-10.398,3.971-12.113c0.584,1.713,2.759,8.075,3.643,10.375c2.598,6.735,5.913,15.534,6.268,16.463
                                c0.366,0.974,0.881,1.645,1.811,1.645h9.008c0.89,0,1.303-1.021,0.884-1.906c-1.005-2.11-9.561-22.896-15.495-36.563
                                c0,0,15.413-34.021,15.715-34.863C458.811,407.68,458.723,406.792,457.451,406.792z"/>


                     <g fill="rgb-icc(#CMYK, 0, 0.96, 1, 0)">
                            <!-- letter Y of english logo -->
                            <path
                                d="M175.729, 441.647v-1.822c6.201-17.32,30.664-78.19,30.914-78.876c0.299-0.839,0.211-1.728-1.061-1.728
                                    H194.71c-0.924,0-1.502,0.451-1.634,1.105c-0.134,0.662-17.043,47.268-18.173,51.209c-0.913,3.187-4.806,15.54-4.806,15.54h-0.473
                                    L175.729,441.647z"/>

                            <path
                                 d="M164.828,411.81c-1.311-4.056-13.885-39.194-14.253-40.6c-0.206-0.771-0.556-1.729-1.911-1.729h-10.198
                                    c-0.994,0-1.56,1.092-1.237,1.77c0.255,0.544,18.673,49.537,26.11,68.251v41.152c0,0.75,0.3,1.203,1.05,1.203h10.292
                                    c0.6,0,1.048-0.453,1.048-1.203v-40.829L164.828,411.81z"/>
                    </g>
                    </g></xsl:when><xsl:otherwise>
                        <path fill="rgb-icc(#CMYK,0.0, 0.96, 1.0, 0.0)" d="M21.334,61.417h-2.761c-2.716,0-5.017,2.065-5.017,6.074c0,2.405,1.115,4.179,3.103,5.054l-3.705,6.706
                            c-0.121,0.218,0,0.391,0.19,0.391h1.723c0.145,0,0.239-0.051,0.291-0.173l3.363-6.584h1.212v6.584c0,0.073,0.073,0.173,0.169,0.173
                            h1.505c0.146,0,0.191-0.073,0.191-0.194V61.659C21.601,61.489,21.504,61.417,21.334,61.417 M19.736,71.329h-1.018
                            c-1.598,0-3.148-1.166-3.148-4.082c0-3.037,1.453-4.273,2.933-4.273h1.233V71.329z"/>
                            <path d="M30.438,67.457h-1.502c-0.121,0-0.19,0.1-0.19,0.17v4.643h-2.786v-4.643c0-0.121-0.048-0.17-0.169-0.17h-1.503
                                c-0.12,0-0.193,0.073-0.193,0.17v11.811c0,0.121,0.049,0.191,0.169,0.191h1.527c0.097,0,0.169-0.07,0.169-0.191v-5.639h2.786v5.639
                                c0,0.121,0.069,0.191,0.19,0.191h1.502c0.121,0,0.17-0.098,0.17-0.191V67.627C30.608,67.53,30.536,67.457,30.438,67.457"/>
                            <path d="M64.726,78.852l-0.191-0.826c-0.023-0.073-0.051-0.097-0.12-0.097c-0.121,0-0.776,0.267-1.723,0.267
                                c-1.841,0-2.734-1.772-2.734-4.592c0-2.479,0.751-4.935,2.01-4.935c0.339,0,0.751,0.1,1.405,0.705c0.07,0.072,0.121,0.1,0.191,0.1
                                c0.072,0,0.146-0.053,0.221-0.174l0.651-1.065c0.048-0.074,0.073-0.147,0.073-0.22c0-0.1-0.097-0.173-0.243-0.242
                                c-0.993-0.511-1.671-0.608-2.252-0.608c-2.277,0-4.046,2.721-4.046,6.976c0,3.669,1.696,5.78,4.118,5.78
                                c1.018,0,2.105-0.483,2.544-0.803C64.726,79.046,64.75,78.949,64.726,78.852"/>
                            <path d="M54.199,72.948l2.903-5.321c0.049-0.07,0.024-0.169-0.07-0.169h-1.432c-0.411,0-0.557,0.146-0.701,0.461l-2.181,4.543
                                c-0.12,0.271-0.242,0.438-0.363,0.514v-5.349c0-0.097-0.048-0.169-0.145-0.169h-1.574c-0.073,0-0.146,0.072-0.146,0.169V79.46
                                c0,0.073,0.048,0.17,0.146,0.17h1.574c0.097,0,0.145-0.07,0.145-0.17v-6.099c0.073,0.049,0.121,0.122,0.17,0.219l2.764,5.688
                                c0.145,0.292,0.36,0.362,0.678,0.362h1.55c0.097,0,0.121-0.097,0.073-0.17L54.199,72.948z"/>
                            <path d="M40.321,78.098H40.03c-0.36,0-0.46-0.146-0.46-0.438V67.626c0-0.121-0.049-0.17-0.145-0.17h-4.844
                                c-0.121,0-0.194,0.073-0.194,0.17v0.875c0,2.94-0.17,6.729-1.72,9.6h-0.533c-0.146,0-0.194,0.07-0.194,0.192v3.547
                                c0,0.122,0.1,0.17,0.17,0.17h1.163c0.269,0,0.363-0.19,0.363-0.362v-2.019h5.184v2.211c0,0.1,0.071,0.17,0.168,0.17h1.236
                                c0.146,0,0.29-0.119,0.29-0.362v-3.354C40.514,78.171,40.442,78.098,40.321,78.098 M37.705,78.098h-3.515
                                c1.236-2.113,1.723-4.495,1.892-7.41c0.049-0.632,0.07-1.288,0.07-1.701h1.553V78.098z"/>
                            <path d="M45.262,67.166c-2.616,0-3.779,3.304-3.779,6.9c0,3.669,1.647,5.854,4.069,5.854c1.187,0,2.229-0.461,2.761-0.802
                                c0.1-0.049,0.121-0.121,0.1-0.218l-0.194-0.826c-0.024-0.097-0.073-0.146-0.194-0.146c-0.096,0-0.799,0.27-1.792,0.27
                                c-1.862,0-2.734-1.628-2.734-3.765v-0.576c0,0,0.941,0.11,1.502,0.11h3.535v-1.021C48.531,69.182,47.198,67.166,45.262,67.166
                                M44.996,72.438c-0.561,0-1.432,0.097-1.432,0.097s0-0.364,0.052-0.753c0.217-2.066,0.726-3.11,1.571-3.11
                                c0.775,0,1.262,1.069,1.38,2.94c0.024,0.388,0.024,0.826,0.024,0.826H44.996z"/>

                    </xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="contains(address2, 'Burlingame')">
                    <path d="M25.544,86.462h0.648l-1.47,2.592v1.608h-0.576v-1.608l-1.47-2.592h0.648l1.11,2.022L25.544,86.462z"/>
                        <path d="M26.132,88.124c0.18-0.128,0.363-0.215,0.549-0.261s0.369-0.069,0.549-0.069
                            c0.22,0,0.396,0.026,0.528,0.078c0.132,0.052,0.234,0.115,0.306,0.19c0.052,0.056,0.093,0.118,0.123,0.186
                            c0.03,0.067,0.053,0.135,0.069,0.203c0.016,0.067,0.025,0.134,0.027,0.2c0.002,0.065,0.003,0.126,0.003,0.182v0.968
                            c0,0.067,0.001,0.142,0.003,0.224c0.002,0.081,0.021,0.145,0.057,0.188c0.048,0.061,0.124,0.08,0.228,0.061l-0.072,0.438
                            c-0.096,0.024-0.187,0.027-0.273,0.009c-0.086-0.018-0.157-0.049-0.213-0.093c-0.044-0.032-0.082-0.076-0.114-0.132
                            c-0.032-0.056-0.056-0.114-0.072-0.174c-0.044,0.048-0.098,0.099-0.162,0.152c-0.064,0.055-0.13,0.098-0.198,0.13
                            c-0.068,0.035-0.151,0.065-0.249,0.09c-0.098,0.023-0.213,0.036-0.345,0.036c-0.112,0-0.229-0.015-0.351-0.042
                            c-0.122-0.028-0.235-0.095-0.339-0.198c-0.064-0.061-0.122-0.142-0.174-0.243c-0.052-0.102-0.078-0.227-0.078-0.375
                            c0-0.14,0.026-0.259,0.078-0.357c0.052-0.098,0.108-0.177,0.168-0.236c0.06-0.061,0.125-0.109,0.195-0.147
                            c0.07-0.038,0.141-0.069,0.213-0.096c0.072-0.026,0.141-0.046,0.207-0.061c0.066-0.014,0.125-0.024,0.177-0.032
                            c0.128-0.021,0.265-0.034,0.411-0.042s0.277-0.013,0.393-0.013v-0.029c0-0.083-0.006-0.173-0.018-0.268
                            c-0.012-0.095-0.052-0.173-0.12-0.231c-0.056-0.052-0.125-0.086-0.207-0.102s-0.157-0.023-0.225-0.023
                            c-0.088,0-0.168,0.008-0.24,0.023c-0.072,0.016-0.142,0.033-0.21,0.053c-0.064,0.02-0.126,0.042-0.186,0.067
                            s-0.124,0.058-0.192,0.096L26.132,88.124z M27.788,89.3c-0.012,0-0.046,0.001-0.102,0.003s-0.12,0.007-0.192,0.013
                            c-0.072,0.006-0.147,0.013-0.225,0.021c-0.078,0.008-0.147,0.019-0.207,0.03c-0.08,0.016-0.161,0.04-0.243,0.072
                            c-0.082,0.031-0.149,0.071-0.201,0.12c-0.032,0.031-0.063,0.073-0.093,0.126c-0.03,0.052-0.045,0.115-0.045,0.191
                            c0,0.08,0.014,0.144,0.042,0.189c0.028,0.046,0.054,0.081,0.078,0.104c0.056,0.052,0.117,0.085,0.183,0.1
                            c0.066,0.014,0.127,0.021,0.183,0.021c0.056,0,0.113-0.005,0.171-0.015s0.119-0.029,0.183-0.058
                            c0.08-0.036,0.163-0.089,0.249-0.158c0.086-0.07,0.159-0.14,0.219-0.207V89.3z"/>
                        <path d="M29.678,87.86v0.336c0.016-0.017,0.056-0.054,0.12-0.114c0.064-0.06,0.142-0.114,0.234-0.162
                            c0.092-0.052,0.183-0.086,0.273-0.102c0.09-0.017,0.181-0.024,0.273-0.024c0.04,0,0.088,0.002,0.144,0.006
                            c0.056,0.004,0.115,0.015,0.177,0.03s0.124,0.04,0.186,0.072s0.121,0.074,0.177,0.126c0.108,0.107,0.174,0.236,0.198,0.384
                            c0.024,0.148,0.036,0.296,0.036,0.444v1.806h-0.498v-1.799c0-0.212-0.032-0.364-0.096-0.457c-0.028-0.04-0.071-0.079-0.129-0.117
                            s-0.141-0.057-0.249-0.057c-0.1,0-0.188,0.016-0.264,0.048c-0.076,0.032-0.154,0.076-0.234,0.132
                            c-0.08,0.057-0.147,0.116-0.201,0.178c-0.054,0.062-0.103,0.121-0.147,0.178v1.895h-0.498V87.86H29.678z"/>
                        <path d="M34.736,90.662h-0.498v-0.3c-0.068,0.08-0.14,0.144-0.216,0.191c-0.076,0.049-0.153,0.085-0.231,0.111
                            s-0.154,0.043-0.228,0.051c-0.074,0.008-0.143,0.013-0.207,0.013c-0.16,0-0.306-0.021-0.438-0.063
                            c-0.132-0.042-0.26-0.127-0.384-0.255c-0.156-0.16-0.261-0.336-0.315-0.528c-0.054-0.191-0.081-0.386-0.081-0.582
                            c0-0.155,0.013-0.296,0.039-0.42c0.026-0.124,0.058-0.232,0.096-0.327c0.038-0.094,0.08-0.175,0.126-0.242
                            c0.046-0.068,0.091-0.124,0.135-0.168c0.14-0.148,0.286-0.243,0.438-0.285c0.152-0.042,0.304-0.063,0.456-0.063
                            c0.056,0,0.117,0.004,0.183,0.012c0.066,0.009,0.135,0.024,0.207,0.049c0.072,0.023,0.143,0.06,0.213,0.107
                            c0.07,0.048,0.139,0.114,0.207,0.198v-1.698h0.498V90.662z M34.238,88.648c-0.128-0.161-0.253-0.271-0.375-0.329
                            c-0.122-0.058-0.243-0.087-0.363-0.087c-0.104,0-0.213,0.021-0.327,0.066c-0.114,0.044-0.217,0.137-0.309,0.277
                            c-0.076,0.116-0.124,0.242-0.144,0.377s-0.03,0.249-0.03,0.341c0,0.117,0.013,0.241,0.039,0.371
                            c0.026,0.131,0.081,0.251,0.165,0.359c0.068,0.085,0.146,0.15,0.234,0.196s0.194,0.069,0.318,0.069c0.088,0,0.168-0.012,0.24-0.036
                            c0.072-0.024,0.148-0.064,0.228-0.121c0.028-0.02,0.073-0.057,0.135-0.111c0.062-0.055,0.125-0.128,0.189-0.22V88.648z"/>
                        <path d="M37.875,90.284c-0.112,0.128-0.253,0.234-0.423,0.318s-0.395,0.126-0.675,0.126
                            c-0.084,0-0.168-0.005-0.252-0.013s-0.168-0.024-0.252-0.051s-0.168-0.063-0.252-0.114c-0.084-0.05-0.164-0.114-0.24-0.194
                            c-0.124-0.128-0.222-0.285-0.294-0.472c-0.072-0.186-0.108-0.387-0.108-0.603c0-0.176,0.026-0.354,0.078-0.531
                            c0.052-0.178,0.132-0.338,0.24-0.479c0.108-0.143,0.244-0.258,0.408-0.346c0.164-0.088,0.358-0.132,0.582-0.132
                            c0.248,0,0.453,0.052,0.615,0.154c0.162,0.102,0.291,0.231,0.387,0.388c0.096,0.157,0.163,0.327,0.201,0.512
                            c0.038,0.186,0.057,0.357,0.057,0.519H35.93c0.004,0.146,0.029,0.276,0.075,0.391c0.046,0.115,0.107,0.212,0.183,0.29
                            c0.076,0.079,0.163,0.14,0.261,0.181c0.098,0.042,0.201,0.062,0.309,0.062c0.04,0,0.09-0.003,0.15-0.009s0.124-0.019,0.192-0.038
                            c0.068-0.02,0.139-0.049,0.213-0.088c0.074-0.04,0.149-0.095,0.225-0.165L37.875,90.284z M37.37,88.928
                            c-0.012-0.114-0.04-0.216-0.084-0.303c-0.044-0.088-0.097-0.16-0.159-0.218c-0.062-0.057-0.132-0.101-0.21-0.131
                            c-0.078-0.029-0.157-0.044-0.237-0.044c-0.088,0-0.172,0.015-0.252,0.044c-0.08,0.03-0.152,0.075-0.216,0.134
                            c-0.064,0.06-0.119,0.133-0.165,0.221c-0.046,0.087-0.077,0.187-0.093,0.297H37.37z"/>
                        <path d="M40.808,87.86l-0.966,1.313l1.098,1.488h-0.612l-0.792-1.104l-0.792,1.104h-0.612l1.104-1.488l-0.972-1.313
                            h0.612l0.66,0.924l0.66-0.924H40.808z"/>
                        <path d="M45.843,90.164v0.498h-2.55v-4.2h0.576v3.702H45.843z"/>
                        <path d="M46.359,88.124c0.18-0.128,0.363-0.215,0.549-0.261s0.369-0.069,0.549-0.069
                            c0.22,0,0.396,0.026,0.528,0.078c0.132,0.052,0.234,0.115,0.306,0.19c0.052,0.056,0.093,0.118,0.123,0.186
                            c0.03,0.067,0.053,0.135,0.069,0.203c0.016,0.067,0.025,0.134,0.027,0.2c0.002,0.065,0.003,0.126,0.003,0.182v0.968
                            c0,0.067,0.001,0.142,0.003,0.224c0.002,0.081,0.021,0.145,0.057,0.188c0.048,0.061,0.124,0.08,0.228,0.061l-0.072,0.438
                            c-0.096,0.024-0.187,0.027-0.273,0.009c-0.086-0.018-0.157-0.049-0.213-0.093c-0.044-0.032-0.082-0.076-0.114-0.132
                            c-0.032-0.056-0.056-0.114-0.072-0.174c-0.044,0.048-0.098,0.099-0.162,0.152c-0.064,0.055-0.13,0.098-0.198,0.13
                            c-0.068,0.035-0.151,0.065-0.249,0.09c-0.098,0.023-0.213,0.036-0.345,0.036c-0.112,0-0.229-0.015-0.351-0.042
                            c-0.122-0.028-0.235-0.095-0.339-0.198c-0.064-0.061-0.122-0.142-0.174-0.243c-0.052-0.102-0.078-0.227-0.078-0.375
                            c0-0.14,0.026-0.259,0.078-0.357c0.052-0.098,0.108-0.177,0.168-0.236c0.06-0.061,0.125-0.109,0.195-0.147
                            c0.07-0.038,0.141-0.069,0.213-0.096c0.072-0.026,0.141-0.046,0.207-0.061c0.066-0.014,0.125-0.024,0.177-0.032
                            c0.128-0.021,0.265-0.034,0.411-0.042s0.277-0.013,0.393-0.013v-0.029c0-0.083-0.006-0.173-0.018-0.268
                            c-0.012-0.095-0.052-0.173-0.12-0.231c-0.056-0.052-0.125-0.086-0.207-0.102s-0.157-0.023-0.225-0.023
                            c-0.088,0-0.168,0.008-0.24,0.023c-0.072,0.016-0.142,0.033-0.21,0.053c-0.064,0.02-0.126,0.042-0.186,0.067
                            s-0.124,0.058-0.192,0.096L46.359,88.124z M48.015,89.3c-0.012,0-0.046,0.001-0.102,0.003s-0.12,0.007-0.192,0.013
                            c-0.072,0.006-0.147,0.013-0.225,0.021c-0.078,0.008-0.147,0.019-0.207,0.03c-0.08,0.016-0.161,0.04-0.243,0.072
                            c-0.082,0.031-0.149,0.071-0.201,0.12c-0.032,0.031-0.063,0.073-0.093,0.126c-0.03,0.052-0.045,0.115-0.045,0.191
                            c0,0.08,0.014,0.144,0.042,0.189c0.028,0.046,0.054,0.081,0.078,0.104c0.056,0.052,0.117,0.085,0.183,0.1
                            c0.066,0.014,0.127,0.021,0.183,0.021c0.056,0,0.113-0.005,0.171-0.015s0.119-0.029,0.183-0.058
                            c0.08-0.036,0.163-0.089,0.249-0.158c0.086-0.07,0.159-0.14,0.219-0.207V89.3z"/>
                        <path d="M49.407,86.462h0.498v1.723c0.084-0.084,0.169-0.152,0.255-0.204c0.086-0.053,0.168-0.093,0.246-0.12
                            c0.078-0.028,0.151-0.046,0.219-0.055c0.068-0.008,0.13-0.012,0.186-0.012c0.216,0,0.389,0.035,0.519,0.105
                            c0.13,0.069,0.229,0.139,0.297,0.207c0.08,0.08,0.145,0.167,0.195,0.261c0.05,0.094,0.088,0.188,0.114,0.285
                            c0.026,0.096,0.044,0.191,0.054,0.288c0.01,0.096,0.015,0.184,0.015,0.264c0,0.308-0.041,0.558-0.123,0.75
                            s-0.181,0.346-0.297,0.462c-0.12,0.12-0.247,0.202-0.381,0.246c-0.134,0.044-0.285,0.066-0.453,0.066
                            c-0.08,0-0.165-0.007-0.255-0.019s-0.175-0.038-0.255-0.078c-0.064-0.031-0.125-0.069-0.183-0.113
                            c-0.058-0.044-0.109-0.089-0.153-0.133v0.276h-0.498V86.462z M49.905,89.897c0.044,0.057,0.093,0.107,0.147,0.151
                            c0.054,0.044,0.109,0.082,0.165,0.114c0.08,0.045,0.155,0.077,0.225,0.097c0.07,0.021,0.147,0.03,0.231,0.03
                            c0.096,0,0.184-0.012,0.264-0.036s0.158-0.074,0.234-0.151c0.188-0.188,0.282-0.48,0.282-0.875c0-0.044-0.002-0.097-0.006-0.159
                            c-0.004-0.062-0.012-0.127-0.024-0.193c-0.012-0.066-0.031-0.133-0.057-0.199c-0.026-0.066-0.059-0.128-0.099-0.185
                            c-0.044-0.06-0.108-0.118-0.192-0.175c-0.084-0.056-0.196-0.084-0.336-0.084c-0.092,0-0.178,0.016-0.258,0.048
                            s-0.158,0.076-0.234,0.133c-0.044,0.032-0.086,0.067-0.126,0.105s-0.075,0.073-0.105,0.105c-0.03,0.032-0.055,0.06-0.075,0.082
                            s-0.032,0.035-0.036,0.039V89.897z"/>
                        <path d="M52.755,89.96c0.032,0.031,0.08,0.068,0.142,0.109s0.138,0.081,0.227,0.12
                            c0.161,0.067,0.329,0.101,0.502,0.101c0.044,0,0.109-0.006,0.194-0.018c0.084-0.012,0.161-0.04,0.229-0.084
                            c0.037-0.027,0.072-0.067,0.106-0.119s0.051-0.117,0.051-0.196c0-0.115-0.05-0.209-0.151-0.28
                            c-0.044-0.032-0.099-0.059-0.163-0.081c-0.064-0.021-0.137-0.045-0.218-0.068l-0.38-0.107c-0.105-0.032-0.213-0.067-0.324-0.107
                            s-0.206-0.103-0.287-0.187c-0.057-0.056-0.096-0.117-0.118-0.183c-0.022-0.066-0.033-0.14-0.033-0.22
                            c0-0.128,0.021-0.239,0.063-0.336c0.042-0.096,0.097-0.178,0.165-0.245c0.06-0.061,0.124-0.107,0.192-0.142s0.137-0.06,0.207-0.078
                            c0.07-0.018,0.139-0.029,0.207-0.036c0.068-0.006,0.13-0.009,0.186-0.009c0.092,0,0.189,0.006,0.291,0.019
                            c0.102,0.012,0.207,0.038,0.315,0.077c0.104,0.036,0.193,0.077,0.267,0.123c0.074,0.047,0.135,0.088,0.183,0.123l-0.264,0.366
                            c-0.083-0.055-0.158-0.097-0.224-0.126c-0.065-0.029-0.114-0.05-0.146-0.062c-0.068-0.027-0.136-0.048-0.203-0.062
                            c-0.068-0.014-0.144-0.021-0.227-0.021c-0.06,0-0.125,0.007-0.194,0.021c-0.07,0.014-0.133,0.043-0.188,0.086
                            c-0.048,0.04-0.079,0.08-0.092,0.119c-0.014,0.04-0.021,0.075-0.021,0.107c0,0.056,0.012,0.1,0.036,0.134
                            c0.024,0.033,0.058,0.062,0.102,0.086c0.043,0.024,0.094,0.045,0.152,0.062c0.058,0.018,0.138,0.043,0.242,0.074l0.406,0.12
                            c0.08,0.024,0.17,0.057,0.272,0.099c0.102,0.043,0.188,0.1,0.26,0.172c0.048,0.048,0.094,0.114,0.137,0.2
                            c0.044,0.087,0.066,0.195,0.066,0.327c0,0.137-0.021,0.252-0.063,0.349c-0.042,0.096-0.095,0.178-0.159,0.246
                            c-0.124,0.132-0.262,0.214-0.414,0.245c-0.152,0.032-0.298,0.049-0.438,0.049c-0.116,0-0.232-0.007-0.348-0.019
                            c-0.116-0.012-0.232-0.04-0.348-0.084c-0.116-0.044-0.216-0.095-0.3-0.153c-0.084-0.058-0.154-0.112-0.21-0.164L52.755,89.96z"/></xsl:when>
                    <xsl:otherwise><text transform="matrix(1 0 0 1 19.25 89.1997)"
                                         font-family="'TextBookNewRegular'" font-size="6">
                        <xsl:if test="en">
                            <xsl:attribute name="transform">matrix(1 0 0 1 16.4688 89.1997)</xsl:attribute>
                        </xsl:if><!--xsl:value-of select="$yandex"/--></text>
                    </xsl:otherwise></xsl:choose>
                    <!-- Right arrow -->
                    <polygon fill="none"
                             stroke="rgb-icc(#CMYK, 0, 0.83, 0.80, 0.20)"
                             stroke-width="0.3"
                             points="0.15,0.149 213.592,0.149 254.521,
                             70.795 213.541,141.598 0.15,141.598 "/>
                </svg>
            </fo:instream-foreign-object>
        </fo:block>
    </xsl:template>
</xsl:stylesheet>
