from django.contrib import admin

from staff.lib.utils.admin import AutocompleteMixin

from .models import (
    CityAsStartrekComponent,
    DepartmentAsStartrekComponent,
    SNGCountry,
    TripPurpose,
)


class CityAsStartrekComponentAdmin(admin.ModelAdmin, AutocompleteMixin):
    list_display = (
        'city',
        'component',
        'lang',
        'hr_mobile_email',
        'money_person',
        'hr_person',
    )
    search_fields = ('city__name', 'component')

    staff_field = 'money_person', 'hr_person'

    def formfield_for_foreignkey(self, db_field, request=None, **kwargs):
        autocomplete_field = self.maybe_autocomplete_formfield(db_field)
        if autocomplete_field is not None:
            return autocomplete_field

        return super(CityAsStartrekComponentAdmin, self).formfield_for_foreignkey(
            db_field, request, **kwargs)


class DepartmentAsStartrekComponentAdmin(admin.ModelAdmin):
    list_display = (
        'department',
        'component',
    )
    search_fields = (
        'department__name',
        'component'
    )


class TripPurposeAdmin(admin.ModelAdmin):
    list_display = 'id', 'name', 'name_en', 'intranet_status'
    ordering = 'id', 'intranet_status'


class SNGCountryAdmin(admin.ModelAdmin):
    list_display = ('name', 'spellings')
    search_fields = list_display


admin.site.register(CityAsStartrekComponent, CityAsStartrekComponentAdmin)
admin.site.register(TripPurpose, TripPurposeAdmin)
admin.site.register(
    DepartmentAsStartrekComponent,
    DepartmentAsStartrekComponentAdmin,
)
admin.site.register(SNGCountry, SNGCountryAdmin)
