import logging
from ids.configuration import get_config


logger = logging.getLogger(__name__)


def get_departure_city(city_list):
    return city_list[0]


def get_return_city(city_list):
    if not city_list[-1].get('is_return_route'):
        return None
    dep_city = get_departure_city(city_list).copy()
    ret_city = city_list[-1].copy()

    ret_city.pop('city', None)
    ret_city.pop('country', None)

    dep_city.update(ret_city)
    return dep_city


def make_cities_chain(data):
    sep = ' – '
    cities = []
    city_list = data.get('city_list')
    if not city_list:
        return ''

    departure_city = get_departure_city(city_list)['city']
    return_city = get_return_city(city_list)
    if return_city:
        return_city = return_city['city']

    first_destination_index = 1
    last_destination_index = -1 if return_city else None
    trip_cities = (
        data['city_list'][first_destination_index: last_destination_index]
    )

    cities.append(departure_city)
    cities.append(sep.join(city['city'] for city in trip_cities))
    if return_city:
        cities.append(return_city)

    return sep.join(cities)


def get_issue_url(initial, name):
    key = initial.get(name, {}).get('key')
    if key is None:
        return ''
    else:
        url = '{protocol}://{host}/{key}'
        return url.format(key=key, **get_config('STARTREK'))


def _get_trip_dates(data):
    date_first = data['city_list'][1].get('departure_date')
    date_last = data['city_list'][-1].get('departure_date')
    return date_first, date_last


def update_dates(data):
    data['trip_date_from'], data['trip_date_to'] = _get_trip_dates(data)
    return data
