from django.utils.translation import override

from staff.django_intranet_notifications import Notification

from staff.trip_questionary.utils import get_cityasstartrekcomponent

import logging
logger = logging.getLogger(__name__)


class TripNotification(Notification):
    REPLACE_VOLOZH = False

    def __init__(self, trip_uuid, **params):
        if getattr(self, 'target', None) and 'target' not in params:
            params['target'] = self.target
        super(TripNotification, self).__init__(**params)
        self.trip_uuid = trip_uuid

    def get_subj_id(self):
        return self.trip_uuid

    def send(self, **params):
        if not self.REPLACE_VOLOZH:
            params['notify_forbidden'] = True
        route = self.get_route()
        transport = self.get_transport(route)
        transport.prepare_message(context=self.context, template=self.template)

        logger.warning('TEMPORARY LOG. SEND TRIP: %s' % params)

        return transport.deliver_message(**params)


class I18nTripNotification(TripNotification):
    def __init__(self, trip_uuid, is_personal=False, **params):
        super(I18nTripNotification, self).__init__(trip_uuid, **params)
        self.is_personal = is_personal

    def send(self, **params):
        with override(self.trip_language):
            result = super(I18nTripNotification, self).send(**params)
        return result

    @property
    def trip_language(self):
        author = self.context.get('author')
        langs = [author.lang_ui]

        if self.is_personal:
            langs.append(self.context['employee_data']['employee'].lang_ui)
            if self.context.get('component_city'):
                langs.append(self.context.get('component_city').lang)
        else:
            langs.extend(
                e.get('employee').lang_ui
                for e in self.context.get('employee_list')
            )

        if any(True for lang in langs if lang != 'ru'):
            return 'en'
        else:
            return 'ru'

    @property
    def template(self):
        return self.template_path.format(lang=self.trip_language)


# TRAVEL ISSUES ###
class TripSinglePersonalStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/travel/single-personal.wiki'


class TripMetaStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/travel/meta.wiki'
###


# TRAVEL COMMENTS ###
class StartrekCommonCommentNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/travel/comment-common.wiki'


class StartrekAddCityCommentNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/travel/comment-add-city.wiki'
###


# TRIP AND TRAVEL COMMENTS ###
class StartrekChangePurposeCommentNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/comment-change-purpose.wiki'
###


# INTERCONF ISSUES ###
class TripConfMetaStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/trip_conf/meta.wiki'


class TripConfPersonalStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/trip_conf/personal.wiki'


class TripConfSingleStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/trip_conf/single.wiki'
###


class ConfMetaStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/conf/meta.wiki'


class ConfPersonalStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/conf/personal.wiki'


class ConfSingleStartrekNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    template_path = '{lang}/startrek/interconf/conf/single.wiki'


# ––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––––###


class HrMobileNotification(I18nTripNotification):
    REPLACE_VOLOZH = True
    target = 'TRIP-HR_MOBILE'
    template = 'ru/startrek/hr-mobile.wiki'


class NoticeNotification(TripNotification):
    target = 'TRIP-NOTICE'
    template = 'ru/mail/notice.html'


class TravelClosedNotification(I18nTripNotification):
    target = 'TRAVEL-CLOSED'
    template_path = '{lang}/mail/hr-travel.html'

    @property
    def trip_language(self):
        office = self.context['employee_data']['employee'].office
        component = get_cityasstartrekcomponent(office.city)
        return component.lang
