from staff.trip_questionary.controller.conditions import TripConditions
from staff.lib.utils.library import Library


lib = Library(lambda o: o.__name__)


class OperationBase(object):

    def __init__(self, **kwargs):
        for name, value in kwargs.items():
            setattr(self, name, value)
        self.TC = TripConditions(**kwargs)

    def run(self):
        if self.operation_in_delayed():
            self.del_from_delayed()

    def match_preconditions(self):
        return self.operation_in_delayed()

    def match_diff_preconditions(self):
        return False

    def operation_in_delayed(self):
        return self.name in self._get_delayed_operations()

    def set_to_delayed(self):
        if not self.operation_in_delayed():
            self._get_delayed_operations().append(self.name)

    def del_from_delayed(self):
        self._get_delayed_operations().remove(self.name)

    @property
    def name(self):
        return self.__class__.__name__

    def _get_delayed_operations(self):
        return self._get_main_data().setdefault('delayed_operations', [])

    def _get_main_data(self):
        if hasattr(self, 'city_data'):
            return self.city_data
        elif hasattr(self, 'employee_data'):
            return self.employee_data
        else:
            return self.trip.data
