from staff.trip_questionary.controller.notifications import (
    TripConfMetaStartrekNotification,
    TripConfPersonalStartrekNotification,
    TripConfSingleStartrekNotification,

    ConfMetaStartrekNotification,
    ConfPersonalStartrekNotification,
    ConfSingleStartrekNotification,

    TripMetaStartrekNotification,
    TripSinglePersonalStartrekNotification,
)

from .creation_base import (
    SingleStOperation,
    MetaStOperation,
    PersonalStOperation,
    TripMixin,
    TripEmployeeMixin,
    ConfMixin,
    ConfEmployeeMixin,
)

from ..base import lib


#############################################################################
# TRIP #
#############################################################################

@lib.register
class SingleTripTravel(SingleStOperation, TripEmployeeMixin, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip
            and
            self.TC.is_single
            and
            not self.TC.is_trip_toplevel_issue_created
        )

    def get_notification_class(self):
        return TripSinglePersonalStartrekNotification


@lib.register
class MetaTripTravel(MetaStOperation, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip
            and
            self.TC.is_group
            and
            not self.TC.is_trip_toplevel_issue_created
        )

    def get_notification_class(self):
        return TripMetaStartrekNotification


@lib.register
class PersonalTripTravel(PersonalStOperation, TripEmployeeMixin, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip
            and
            self.TC.is_group
            and
            self.TC.is_trip_toplevel_issue_created
            and
            not self.TC.is_trip_personal_issues_created
            and
            not self.TC.is_trip_employee_issue_created
        )

    def get_notification_class(self):
        return TripSinglePersonalStartrekNotification


#########################################################################
# CONF #
#########################################################################

@lib.register
class PersonalConfInterconf(PersonalStOperation, ConfEmployeeMixin, ConfMixin):
    def match_preconditions(self):
        return (
            self.TC.is_conf
            and
            self.TC.is_group
            and
            self.TC.is_conf_toplevel_issue_created
            and
            not self.TC.is_conf_personal_issues_created
            and
            not self.TC.is_conf_employee_issue_created
        )

    def get_notification_class(self):
        return ConfPersonalStartrekNotification


@lib.register
class MetaConfInterconf(MetaStOperation, ConfMixin):
    def match_preconditions(self):
        return (
            self.TC.is_conf
            and
            self.TC.is_group
            and
            not self.TC.is_conf_toplevel_issue_created
        )

    def get_notification_class(self):
        return ConfMetaStartrekNotification

    def get_send_params(self):
        params = super(MetaConfInterconf, self).get_send_params()
        followers = params.setdefault('followers', [])

        # Все HRBP  в наблюдатели для interconf
        for hrbp_list in self.trip.get_hr_partners().values():
            for hrbp in hrbp_list:
                followers.append(hrbp['login'])

        tags = params.setdefault('tags', [])
        tags.append('Общий')
        return params


@lib.register
class SingleConfInterconf(SingleStOperation, ConfEmployeeMixin, ConfMixin):
    def match_preconditions(self):
        return (
            self.TC.is_conf
            and
            self.TC.is_single
            and
            not self.TC.is_conf_toplevel_issue_created
        )

    def get_notification_class(self):
        return ConfSingleStartrekNotification


##########################################################################
# TRIP + CONF #
##########################################################################


@lib.register
class SingleTripConfInterconf(SingleConfInterconf, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_single
            and
            not self.TC.is_conf_toplevel_issue_created
        )

    def get_notification_class(self):
        return TripConfSingleStartrekNotification


@lib.register
class MetaTripConfInterconf(MetaConfInterconf, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_group
            and
            not self.TC.is_conf_toplevel_issue_created
        )

    def get_notification_class(self):
        return TripConfMetaStartrekNotification


@lib.register
class PersonalTripConfInterconf(PersonalConfInterconf, TripMixin):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_group
            and
            self.TC.is_conf_toplevel_issue_created
            and
            not self.TC.is_conf_personal_issues_created
            and
            not self.TC.is_conf_employee_issue_created
        )

    def get_notification_class(self):
        return TripConfPersonalStartrekNotification

#############


@lib.register
class SingleTripConfTravel(SingleTripTravel):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_single
            and
            not self.TC.is_trip_toplevel_issue_created
        )

    def get_approver(self):
        return


@lib.register
class MetaTripConfTravel(MetaTripTravel):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_group
            and
            not self.TC.is_trip_toplevel_issue_created
        )


@lib.register
class PersonalTripConfTravel(PersonalTripTravel):
    def match_preconditions(self):
        return (
            self.TC.is_trip_conf
            and
            self.TC.is_group
            and
            self.TC.is_trip_toplevel_issue_created
            and
            not self.TC.is_trip_personal_issues_created
            and
            not self.TC.is_trip_employee_issue_created
        )

    def get_approver(self):
        return
