from itertools import product, chain

from staff.trip_questionary.controller.operations.base import OperationBase, lib
from staff.trip_questionary.controller.conditions import event_types_of
from staff.trip_questionary.control import set_issue, set_component, set_synced_time


@lib.register
class SyncIssues(OperationBase):
    def match_preconditions(self):
        return (
            self.TC.is_all_toplevel_issues_created
            and
            self.TC.is_all_personal_issues_created
        )

    def run(self):
        issues = self.operations_cache.st_issues.get_issues(
            self._get_issues_keys()
        )
        issues = {issue['key']: issue for issue in issues}

        for event_type, obj in self._get_event_type_obj():
            issue = issues.get(self._extract_key(obj, event_type))
            if issue:
                set_issue(obj, issue, event_type)
                set_component(obj, issue, event_type)

        set_synced_time(self.trip)

    @staticmethod
    def _extract_key(obj, event_type):
        return obj[event_type + '_issue']['key']

    def _get_issues_keys(self):
        return list(set(
            self._extract_key(obj, event_type) for event_type, obj in self._get_event_type_obj()
        ))

    def _get_event_type_obj(self):
        return product(event_types_of(self.trip), self._get_objects())

    def _get_objects(self):
        return chain(self.trip.data['employee_list'], [self.trip.data])
