from staff.trip_questionary.models import TripQuestionaryCollection
from staff.trip_questionary import tasks
from staff.trip_questionary import control


collection = TripQuestionaryCollection()


class InitiatorsSingle(object):
    def __init__(self, trip):
        self.trip = trip

    def __iter__(self):
        yield self.trip.data
        yield self.trip.data['employee_list'][0]


class InitiatorsGroup(object):
    def __init__(self, trip, login=None):
        self.trip = trip
        self.login = login

    def __iter__(self):
        if self.login:
            initiators = [
                emp for emp in self.trip.data['employee_list']
                if emp['employee'].login == self.login
            ]
            if len(initiators) != 1:
                raise RuntimeError('No such person in this trip')

            return iter(initiators)

        else:
            return iter([self.trip.data])


class TripSurgeon(object):
    def __init__(self, trip_uuid):
        self.trip = collection.get(uuid=trip_uuid)

    def _set_issue(self, initiators, issue_key):
        author = self.trip.data['author']
        issue = self.get_issue(issue_key, author)
        event_type = self.get_event_type(issue_key)
        for initiator in initiators:
            control.set_issue(initiator, issue, event_type)
        self.trip.save()

    def set_issue_single(self, issue_key):
        initiators = InitiatorsSingle(self.trip)
        self._set_issue(initiators, issue_key)

    def get_issue(self, issue_key, author):
        getter = tasks.IssueGetter(author)
        return getter.get_issues([issue_key])[0]

    def get_event_type(self, issue_key):
        return {
            'TRAVEL': 'trip', 'INTERCONF': 'conf'
        }[issue_key.split('-')[0]]

    def set_issue_group(self, issue_key, login=None):
        initiators = InitiatorsGroup(self.trip, login)
        self._set_issue(initiators, issue_key)
