# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CityAsStartrekComponent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('component', models.CharField(verbose_name='Стартречный компонент', max_length=50)),
                ('trip_money_email', models.CharField(verbose_name='trip-money@', max_length=512)),
                ('hr_travel_email', models.CharField(verbose_name='hr-travel@', max_length=512)),
                ('hr_mobile_email', models.CharField(verbose_name='hr-mobile@', max_length=512)),
                ('lang', models.CharField(verbose_name='Язык', max_length=2)),
                ('mailing_list', models.CharField(verbose_name='Рассылка', max_length=512)),
                ('city', models.OneToOneField(verbose_name='Город', to='django_intranet_stuff.City')),
                ('hr_person', models.ForeignKey(verbose_name='HR ex hr travel', related_name='+', to='django_intranet_stuff.Staff')),
                ('money_person', models.ForeignKey(verbose_name='Бухгалтер ex trip money', related_name='+', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='DepartmentAsStartrekComponent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('component', models.CharField(verbose_name='Стартречный компонент', max_length=50)),
                ('department', models.OneToOneField(verbose_name='Департамент', to='django_intranet_stuff.Department')),
            ],
        ),
        migrations.CreateModel(
            name='SNGCountry',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(verbose_name='Название', max_length=255)),
                ('spellings', models.TextField(verbose_name='Варианты написания')),
            ],
        ),
        migrations.CreateModel(
            name='TripPurpose',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('name', models.CharField(verbose_name='Название', max_length=128)),
                ('name_en', models.CharField(verbose_name='Англ. название', max_length=128)),
                ('description', models.TextField(verbose_name='Описание')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
