from datetime import datetime, timedelta

from staff.lib.utils.date import get_timedelta_setting

from .models import TripQuestionaryCollection


def get_slowpoke_query(seconds=None):
    """
    Slowpokes are trips with no tickets
    for too much long time (ISSUE_CREATION_INTERVAL)
    """
    now = datetime.now()
    if seconds:
        issue_creation_interval = timedelta(seconds=seconds)
    else:
        issue_creation_interval = get_timedelta_setting('ISSUE_CREATION_INTERVAL')
    return {
        'creation_time': {'$lte': now - issue_creation_interval},
        'trip_issue': {'$exists': False},
        'conf_issue': {'$exists': False},
    }


def get_sync_query():
    now = datetime.now()
    return {
        '$or': [
            {'trip_date_to': {'$gt': now - timedelta(days=4)}},
            {'event_date_to': {'$gt': now - timedelta(days=2)}},
        ],
    }


def get_sync_timeouted_query(interval):
    now = datetime.now()
    q = get_sync_query()
    issue_sync_interval = interval
    q.update({'last_sync': {'$lte': now - issue_sync_interval}})
    return q


def get_wierd_trips():
    return TripQuestionaryCollection().find(get_slowpoke_query())


def get_issue_query(issue_key):
    return {
        '$or': [
            {'trip_issue.key': issue_key},
            {'conf_issue.key': issue_key},
            {'employee_list': {'$elemMatch': {'conf_issue.key': issue_key}}},
            {'employee_list': {'$elemMatch': {'trip_issue.key': issue_key}}},
        ]
    }
