import logging

from django.conf import settings

from staff.lib.requests import get_ids_repository

logger = logging.getLogger(__name__)


class IssueGetter(object):

    def __init__(self, author):
        self.author = author
        self.repository = self.get_repository()

    def get_issues(self, keys):
        st_issues = self.repository.get({'filter': 'key:%s' % ','.join(keys)})
        return st_issues

    def get_repository(self):
        return get_ids_repository(
            'startrek2',
            'issues',
            user_agent=settings.STAFF_USER_AGENT,
            oauth_token=settings.ROBOT_STAFF_OAUTH_TOKEN,
        )
