from django import template
from staff.lib.utils.list import pairs_iterator
from staff.trip_questionary.forms import (
    TRANSPORT,
    EVENT_ROLE,
    ARRIVE_DATE_TYPE,
    FARE,
    BAGGAGE,
    COMPENSATION,
)
from staff.trip_questionary.controller.context import get_issue_url


register = template.Library()


@register.filter
def city_pairs(iterable):
    return pairs_iterator(iterable)


@register.filter
def as_transport(transport_str):
    return dict(TRANSPORT)[transport_str]


@register.filter
def as_fare(fare_str):
    return dict(FARE)[fare_str]


@register.filter
def as_compensation(compensation_str):
    return dict(COMPENSATION)[compensation_str]


@register.filter
def as_baggage(baggage_str):
    return dict(BAGGAGE)[baggage_str]


@register.filter
def as_arrive_type(date_type):
    return dict(ARRIVE_DATE_TYPE)[date_type]


@register.filter
def page_generator(trip_list):

    cur_page = trip_list.number
    all_page = trip_list.paginator.num_pages

    start = 1 if cur_page < 10 else cur_page - 10
    stop = all_page if all_page - cur_page < 10 else cur_page + 10

    old_page = start - 10 if start - 10 > 0 else 1
    new_page = stop + 10 if stop + 10 <= all_page else all_page

    if start != old_page:
        yield '«', old_page

    for i in range(start, stop):
        yield i, i

    if stop != new_page:
        yield '»', new_page


@register.filter
def as_event_role(role_id):
    return EVENT_ROLE[role_id]


@register.filter
def issue_url(data_or_employee_dict, name):
    return get_issue_url(data_or_employee_dict, name)


@register.filter
def issue_files_url(issue_url):
    trailing_slash = '' if issue_url.endswith('/') else '/'
    return '{url}{slash}files'.format(url=issue_url, slash=trailing_slash)


@register.filter
def new_notifictaions(employee_list, logins):
    emp_list = [x for x in employee_list if x.get('employee').login in logins]
    return [x for x in emp_list if not x.get('access_notificated_chiefs')]


@register.filter
def already_notificated(employee_list, logins):
    emp_list = [x for x in employee_list if x.get('employee').login in logins]
    return [x for x in emp_list if x.get('access_notificated_chiefs')]
