from django.conf.urls import url

from staff.trip_questionary import views

urlpatterns = [
    url(r'edit/?$',
        views.edit,
        name='trip_api-redact',),

    url(r'save/?$',
        views.save,
        name='trip_api-save'),

    url(r'admin/list/?$',
        views.admin_trip_list,
        name='trip_api-admin-list'),

    url(r'admin/wierd/?$',
        views.admin_wierd_trip_list,
        name='trip_api-admin-wierd'),

    url(r'admin/start_operators/(?P<trip_uuid>[\w-]{36})/?$',
        views.admin_trip_start_operators,
        name='trip_api-admin-start_operators'),

    url(r'admin/(?P<trip_uuid>[\w-]{36})/?$',
        views.admin_trip,
        name='trip_api-admin-show'),

    url(r'admin/delete/(?P<trip_uuid>[\w-]{36})/?$',
        views.admin_trip_delete,
        name='trip_api-admin-delete'),

    url(r'^old/?$',
        views.trip_history,
        name='trip_questionary-trip_history'),

    url(r'^get_employee_assignments/(?P<login>[\w\-\_\.]+)/?$',
        views.get_employee_assignments,
        name='trip_questionary-get_employee_assignments'),

    url(r'^get_employee_phones/(?P<login>[\w\-\_\.]+)/?$',
        views.get_employee_phones,
        name='trip_questionary-get_employee_phones'),
]
