import logging

from django.conf import settings
from django.core.exceptions import ObjectDoesNotExist

from staff.map.models import City

logger = logging.getLogger(__name__)


def get_default_city_component():
    return (
        City.objects
        .select_related('cityasstartrekcomponent')
        .get(id=settings.DEFAULT_CITY_ID)
    ).cityasstartrekcomponent


def get_cityasstartrekcomponent(city):
    try:
        return city.cityasstartrekcomponent
    except (AttributeError, ObjectDoesNotExist):
        return get_default_city_component()


def if_any_field(collection, field_name, true_value, false_value):
    for x in collection:
        if x.get(field_name):
            return true_value
    return false_value


def sum_all_field(collection, field_name):
    result = 0.0
    for x in collection:
        value = x.get(field_name)
        if value:
            result += float(value)  # не ок (c) another
    return result


def get_assignment_line(assignment_dict):
    return '{taxUnitName}, {orgName}, {assignmentID}'.format(**assignment_dict)
