import logging

from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_http_methods

from staff.lib.decorators import auth_by_tvm_only

from staff.umbrellas.controllers import export_umbrellas
from staff.umbrellas.forms import ExportUmbrellasForm


logger = logging.getLogger(__name__)


@csrf_exempt
@require_http_methods(['GET'])
@auth_by_tvm_only(['review'])
def export_umbrellas_view(request):
    form = ExportUmbrellasForm(request.GET)

    if not form.is_valid():
        return JsonResponse(data=form.errors_as_dict(), status=400)

    return JsonResponse(data=export_umbrellas(form.cleaned_data.get('continuation_token'), 1000), status=200)
