import json
import logging

from django.http import JsonResponse, HttpResponse
from django.views.decorators.http import require_http_methods

from staff.umbrellas.controllers import update_umbrella_assignments
from staff.umbrellas.forms import UmbrellaAssignmentForm


logger = logging.getLogger(__name__)


@require_http_methods(['POST'])
def umbrella_assignment_view(request):
    try:
        form = UmbrellaAssignmentForm(json.loads(request.body))
    except ValueError:
        logger.info('Invalid JSON received', exc_info=True)
        return JsonResponse({}, status=400)

    if not form.is_valid():
        return JsonResponse(data=form.errors_as_dict(), status=400)

    from staff.person_profile.permissions.properties import Properties
    properties = Properties(
        target_logins=[person.login for person in form.cleaned_data['persons']],
        observer=request.user.get_profile(),
        readonly=True,
    )

    if any(not properties.get_is_chief(person.login) for person in form.cleaned_data['persons']):
        return HttpResponse('', status=403)

    update_umbrella_assignments(form.cleaned_data['persons'], form.cleaned_data['umbrellas'])
    return HttpResponse('', status=204)
