from django.conf.urls import include, url
from django.contrib import admin

from staff.lib.utils import initialize

from staff import views

admin.autodiscover()
initialize('handlers')

urlpatterns = [

    url(r'^admin/', include(admin.site.urls), name='admin'),

    # API
    url(r'^api/login_links/', include('staff.verification.urls_api', namespace='verification-api')),
    url(r'^api/', include('staff.api.urls')),

    # profile - анкета
    url(r'^profile-api/', include('staff.person_profile.urls', namespace='profile')),

    # keys
    url(r'^keys/', include('staff.keys.urls', namespace='keys')),

    # avatar
    url(r'^photo/', include('staff.person_avatar.urls')),
    url(r'^avatar/', include('staff.person_avatar.urls')),

    # departments
    url(r'^departments/', include('staff.departments.urls_front', namespace='departments-frontend')),
    url(r'^departments-api/', include('staff.departments.urls', namespace='departments-api')),

    url(r'^proposal/', include('staff.departments.urls_front', namespace='proposal-frontend')),
    url(r'^proposal-api/', include('staff.proposal.urls', namespace='proposal-api')),
    url(r'^budget-position-api/', include('staff.budget_position.urls', namespace='budget-position-api')),

    # groups
    url(r'^groups/', include('staff.groups.urls', namespace='groups')),

    url(r'^reports/', include('staff.reports.urls')),
    # filter
    url(r'^filters-api/', include('staff.person_filter.urls', namespace='filters')),


    url(r'^map/', include('staff.map.urls'), name='map'),
    url(r'^map-api/', include('staff.map.urls', namespace='map'), name='map'),

    url(r'^card-api/', include('staff.card_order.urls', namespace='card-api')),

    url(r'^lenta/', include('staff.lenta.urls')),
    url(r'^lenta-api/', include('staff.lenta.urls_api', namespace='lenta')),

    # Аудит
    url(r'^audit/', include('staff.audit.urls', namespace='audit')),

    url(r'^dismissal/', include('staff.dismissal.urls')),
    url(r'^dismissal-api/', include('staff.dismissal_api.urls', namespace='dismissal-api')),

    url(r'^oauth/', include('staff.verification.urls', namespace='verification-api')),

    url(r'^innerhire-api/', include('staff.innerhire.urls', namespace='innerhire')),

    url(r'^sendspam/', include('staff.sendspam.urls')),

    url(r'^achievery/mass_give', include('staff.give_achievements.urls')),

    url(r'^oebs-api/', include('staff.oebs.urls', namespace='oebs')),

    url(r'^trip-api/', include('staff.trip_questionary.urls', namespace='trip-api')),

    # Временные ручки для интеграции с сервисом trip
    url(r'^trips-api/', include('staff.trip_questionary.trip_urls', namespace='trips-api')),

    url(r'^echo_picture/?$', views.echo_binary,
        kwargs={'content_type': 'image/png'}, name='echo_picture'),
    url(r'^echo-pdf/?$', views.echo_binary,
        kwargs={'content_type': 'applicaton/pdf'}, name='echo_pdf'),

    url(r'^rfid-api/', include('staff.rfid.urls', namespace='rfid-api')),

    url(r'^celery/', include('staff.celery_tools.urls')),

    url(r'^jabber-api/', include('staff.jabber.urls_api', namespace='jabber-api')),

    url(r'^preprofile/', include('staff.preprofile.urls', namespace='preprofile')),  # Временно STAFF-9777
    url(r'^preprofile-api/', include('staff.preprofile.urls', namespace='preprofile-api')),

    url(r'^survey-api/', include('staff.survey.urls', namespace='survey-api')),

    url(r'^headcounts-api/', include('staff.headcounts.urls', namespace='headcounts-api')),
    url(r'^headcounts-history-api/', include('staff.headcounts_history.urls', namespace='headcounts-history-api')),

    url(r'^flags-api/', include('staff.flags.urls', namespace='flags-api')),
    url(r'^umbrellas/', include('staff.umbrellas.urls')),
    url(r'^syncs/', include('staff.syncs.urls')),
    url(
        r'^workspace-management-api/',
        include('staff.workspace_management.urls', namespace='workspace-management-api'),
    ),

    # Center
    url(r'^jabber/', include('staff.jabber.urls')),
    url(r'^whistlah/', include('staff.whistlah.urls', namespace='whistlah')),
    url(r'^center/', include('staff.apicenter.urls')),

    # пути к карточкам staff_cards и user_cards
    url(r'center/', include('staff.person_profile.urls', namespace='cards')),

    # Navigation
    url(r'^navigation-api/', include('staff.navigation.urls', namespace='navigation')),

    url(r'^_settings/?$', views.show_settings),

    url(r'^_user_settings/', include('staff.user_settings.settings_urls')),

    url(r'^gap-api/', include('staff.gap.urls', namespace='gap')),
    url(r'^_gap_admin/', include('staff.gap.gap_admin.urls', namespace='gap-admin')),

    url(r'^_check/', include('staff.monitorings.urls', namespace='monitorings')),

    # нужно чтобы формировать ссылки на фронт в шаблонах
    url(r'', include('staff.anketa.urls')),
]
