from django.contrib.auth.models import AbstractUser

from staff.person.models import Staff


class User(AbstractUser):
    class Meta:
        db_table = 'auth_user'
        permissions = (
            ('can_view_staff', 'Full access to Staff for external'),
        )

    def get_profile(self) -> Staff:
        if not hasattr(self, '_profile_cache'):
            self._profile_cache = self.staff
        return self._profile_cache
