from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin

from .models import ExternalLogin


class ExternalLoginAdmin(StaffModelAdmin):
    staff_field = 'person'
    list_display = (
        'person',
        'login',
        'uid',
        'status_active',
        'ext_passport_synced',
        'created_at'
    )
    ordering = '-created_at',


admin.site.register(ExternalLogin, ExternalLoginAdmin)
