# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExternalLogin',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('login', models.CharField(max_length=286)),
                ('uid', models.CharField(max_length=30)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('login_type', models.CharField(max_length=1, default='M', choices=[('M', 'Main')])),
                ('status_active', models.BooleanField(verbose_name='External login active status', default=False)),
                ('ext_passport_synced', models.BooleanField(verbose_name='External passport synced', default=False)),
                ('person', models.ForeignKey(verbose_name='Staff user', related_name='external_logins', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='externallogin',
            unique_together=set([('person', 'uid', 'login')]),
        ),
    ]
