from django.db import models

from staff.person.models import Staff
from staff.lib.utils.ordered_choices import StaffChoices


class EXTERNAL_LOGIN_TYPES(StaffChoices):
    MAIN = ('M', 'Main')


class ExternalLogin(models.Model):
    class Meta:
        unique_together = ('person', 'uid', 'login')

    person = models.ForeignKey(
        Staff,
        verbose_name='Staff user',
        related_name='external_logins'
    )
    login = models.CharField(max_length=286)
    uid = models.CharField(max_length=30)
    created_at = models.DateTimeField(auto_now_add=True)
    login_type = models.CharField(
        max_length=1,
        choices=EXTERNAL_LOGIN_TYPES.choices(),
        default=EXTERNAL_LOGIN_TYPES.MAIN
    )
    status_active = models.BooleanField(
        default=False,
        verbose_name='External login active status'
    )
    ext_passport_synced = models.BooleanField(
        default=False,
        verbose_name='External passport synced'
    )
