import json
import base64
from pprint import pformat


from django.views.decorators.http import require_http_methods
from django.views.decorators.csrf import csrf_exempt
from django.views.defaults import page_not_found
from django.http import (
    HttpResponse,
    Http404,
    HttpResponseBadRequest,
)
from django.conf import settings


def show_settings(request):
    if not request.user.is_superuser:
        raise Http404

    def attributes(obj):
        for k in dir(obj):
            yield k, getattr(obj, k)

    tpl = "<html><head></head><body><pre>%s</pre></body></html>"
    resp = tpl % pformat(dict(attributes(settings)), indent=4)
    return HttpResponse(resp)


@csrf_exempt
@require_http_methods(['POST'])
def echo_binary(request, content_type):
    try:
        request_dict = request.POST.dict() or json.loads(request.body)
        base64_data = request_dict['data']
        name = '%s.%s' % (
            request_dict.get('name') or 'untitled',
            content_type.split('/')[-1]
        )
        binary = base64.b64decode(base64_data)
    except Exception as e:
        return HttpResponseBadRequest(e)

    response = HttpResponse(binary)
    response['Content-Disposition'] = 'attachment; filename="%s"' % name
    response['Content-Type'] = content_type
    response['Content-Length'] = len(binary)
    return response


def frontend_view(request, *args, **kwargs):
    return page_not_found(request)
