from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin
from .models import (
    OfficeNet,
    NOCOffice,
    StaffLastOffice
)


class OfficeNetAdmin(StaffModelAdmin):
    list_display = ('__str__', 'office', 'name', 'net')
    list_editable = list_display[1:]
    search_fields = ('net', 'office__name', 'name')
    ordering = ('office', 'name', 'net')


class NOCOfficeAdmin(StaffModelAdmin):
    list_display = ('__str__', 'noc_office_id', 'office')
    list_editable = ('office',)
    search_fields = ('noc_office_id', 'office')


class StaffLastOfficeAdmin(StaffModelAdmin):
    list_display = ('__str__', 'staff', 'office', 'is_vpn', 'updated_at')
    list_filter = ('is_vpn', )
    ordering = ('-updated_at', )
    search_fields = ('office__name', )


admin.site.register(OfficeNet, OfficeNetAdmin)
admin.site.register(NOCOffice, NOCOfficeAdmin)
admin.site.register(StaffLastOffice, StaffLastOfficeAdmin)
