# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='NOCOffice',
            fields=[
                ('noc_office_id', models.IntegerField(verbose_name="NOC's office id", primary_key=True, serialize=False)),
                ('is_vpn', models.BooleanField(verbose_name='Is VPN', default=False)),
                ('office', models.ForeignKey(verbose_name='Staff office id', blank=True, null=True, default=None, to='django_intranet_stuff.Office')),
            ],
        ),
        migrations.CreateModel(
            name='OfficeNet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(max_length=255)),
                ('net', models.CharField(max_length=50)),
                ('first_ip_value', models.DecimalField(blank=True, null=True, max_digits=40, decimal_places=0)),
                ('last_ip_value', models.DecimalField(blank=True, null=True, max_digits=40, decimal_places=0)),
                ('office', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Office')),
            ],
        ),
        migrations.CreateModel(
            name='StaffLastOffice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('office_name', models.CharField(max_length=255, default='')),
                ('office_name_en', models.CharField(max_length=255, default='')),
                ('is_vpn', models.BooleanField(default=False)),
                ('updated_at', models.DateTimeField()),
                ('office', models.ForeignKey(null=True, to='django_intranet_stuff.Office')),
                ('staff', models.OneToOneField(to='django_intranet_stuff.Staff')),
            ],
        ),
    ]
